(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10833,        383]
NotebookOptionsPosition[      9389,        331]
NotebookOutlinePosition[      9784,        348]
CellTagsIndexPosition[      9741,        345]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 ".NET/Link Example: EnumWindows\n\n",
 StyleBox["This example demonstrates calling \"unmanaged\" Windows DLLs (that \
is, an old C-style DLLs, not .NET assemblies) from ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" using ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DefineDLLFunction", "Input",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[". It demonstrates the use of ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DefineNETDelegate",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" and ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["NETNewDelegate",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" to call a C function that takes a ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["callback function pointer",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" as an argument.\n\nThe function called is the Windows API \
function EnumWindows. The example demonstrates how to collect a list of the \
HWNDs of all the windows that exist on your system.\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code and Explanation", "Section"],

Cell["Needs[\"NETLink`\"]", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False],

Cell[TextData[{
 "Here is the C-language prototype for the ",
 StyleBox["EnumWindows", "MR"],
 " function, straight out of the Windows API documentation. This function is \
found in ",
 StyleBox["user32.dll", "Output"],
 ":"
}], "Text"],

Cell[TextData[{
 StyleBox["BOOL EnumWindows (WNDENUMPROC lpEnumFunc, LPARAM lParam)",
  FormatType->InputForm],
 ";"
}], "Program"],

Cell[TextData[{
 "The first argument is a function pointer that is used as a callback by the \
internals of ",
 StyleBox["EnumWindows", "MR"],
 ". For every window, the callback function is called with two arguments: the \
",
 StyleBox["HWND", "MR"],
 " of the window and the ",
 StyleBox["lParam", "MR"],
 " argument (which can be any data that you want to have passed to your \
callback). Here is the signature that the callback function must adhere to:"
}], "Text"],

Cell[TextData[{
 "BOOL CALLBACK EnumWindowsProc (HWND hWnd",
 StyleBox[", ",
  FontSlant->"Italic"],
 "LPARAM ",
 StyleBox["lParam",
  FormatType->InputForm],
 ");"
}], "Program"],

Cell[TextData[{
 ".NET maps delegates to C function pointers, so to supply a .NET function to \
be called for the ",
 StyleBox["EnumWindowsProc", "MR"],
 ", you simply need to create an instance of a .NET delegate type that \
matches the ",
 StyleBox["EnumWindowsProc", "MR"],
 " signature. Unfortunately, there is no built-in .NET delegate type having \
the required signature. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides the ",
 StyleBox["DefineNETDelegate",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " function to allow you to define a new delegate type from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. This is how you define the appropriate delegate type:"
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
delegateType = DefineNETDelegate[\"EnumWindowsCallback\", \"BOOL\", \
{\"HWND\", \"LPARAM\"}]\
\>", "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{"NETType", "[", 
  RowBox[{"\<\"Wolfram.NETLink.DynamicDelegateNamespace.EnumWindowsCallback$1\
\"\>", ",", "18"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The first argument is the name given to the type, and it can be any legal \
type name you like. The second argument is the return type of the delegate, \
and the third argument is a list of the argument types. These last arguments \
are interpreted in the same way as the last arguments to ",
 StyleBox["DefineDLLFunction",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 ". Note that ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " understands some common Win32 types like ",
 StyleBox["BOOL", "MR"],
 " (mapped to ",
 StyleBox["int", "MR"],
 "), ",
 StyleBox["LPARAM", "MR"],
 " (mapped to ",
 StyleBox["int", "MR"],
 "), and ",
 StyleBox["HWND", "MR"],
 " (mapped to ",
 StyleBox["IntPtr", "MR"],
 ")."
}], "Text"],

Cell[TextData[{
 "The above call to ",
 StyleBox["DefineNETDelegate",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " does not create a delegate object\[LongDash]it just declares a new type. \
It is analogous to the following line in a C# program."
}], "Text"],

Cell["delegate int EnumWindowsCallback(IntPtr hwnd, int lparam);", "Program"],

Cell[TextData[{
 "Now that you have defined a delegate type with the appropriate signature, \
you can call ",
 StyleBox["DefineDLLFunction",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " to create a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that calls the ",
 StyleBox["EnumWindows", "MR"],
 " function. You pass the ",
 StyleBox["delegateType", "MR"],
 " object returned from ",
 StyleBox["DefineNETDelegate",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " as the type descriptor for the first argument slot of the ",
 StyleBox["EnumWindows", "MR"],
 " function. ",
 StyleBox["DefineDLLFunction",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " is usually called with strings to specify the types (e.g., \"int\", \"BOOL\
\", etc.), but you can also pass in a .NET ",
 StyleBox["Type", "MR"],
 " object, which is what you are doing here. When .NET sees a delegate type \
in a DLL function declaration, it knows to marshal the argument as a function \
pointer."
}], "Text"],

Cell["\<\
EnumWindows = DefineDLLFunction[\"EnumWindows\", \"user32.dll\", \"BOOL\", \
{delegateType, \"LPARAM\"}];\
\>", "Input",
 InitializationCell->True],

Cell[TextData[{
 "It still remains to create an actual instance of the new delegate type. As \
always, you use ",
 StyleBox["NETNewDelegate",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " to create this instance."
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
callbackDelegate = NETNewDelegate[delegateType, EnumWindowsCallbackFunction]\
\>", "Input",
 InitializationCell->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"Wolfram.NETLink.DynamicDelegateNamespace.EnumWindowsCallback$1\"\
\>", "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$1973802334420993]], "Output"]
}, Open  ]],

Cell[TextData[{
 "All that is left is to define the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 StyleBox["EnumWindowsCallbackFunction", "MR"],
 ". The function should return 0 to stop the enumeration, or 1 to continue. \
Because all calls to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " defined via ",
 StyleBox["NETNewDelegate",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " are implicitly wrapped in ",
 StyleBox["NETBlock",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 ", if you want an object to persist beyond the bounds of the call, you need \
to call ",
 StyleBox["KeepNETObject",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " on it. That is necessary here because you are accumulating the ",
 StyleBox["HWND", "MR"],
 "s in a persistent list, and each ",
 StyleBox["HWND", "MR"],
 " is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as an ",
 StyleBox["IntPtr", "MR"],
 " object."
}], "Text"],

Cell["\<\
EnumWindowsCallbackFunction[hwnd_, lparam_] := (AppendTo[hwnds, hwnd]; \
KeepNETObject[hwnd]; 1)
hwnds = {};\
\>", "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["\<\
EnumWindows[callbackDelegate, 0];
hwnds\
\>", "Input"],

Cell[TextData[{
 "The list of ",
 StyleBox["HWND", "MR"],
 "s can be operated on by other Windows API functions, such as those in the \
companion example file WindowsAPI.nb."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1007, 706},
WindowMargins->{{0, Automatic}, {Automatic, -1}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 2086, 63, 271, "Title"],
Cell[CellGroupData[{
Cell[2701, 90, 39, 0, 67, "Section"],
Cell[2743, 92, 116, 3, 30, "Input",
 InitializationCell->True],
Cell[2862, 97, 236, 7, 33, "Text"],
Cell[3101, 106, 131, 4, 42, "Program"],
Cell[3235, 112, 468, 11, 52, "Text"],
Cell[3706, 125, 179, 8, 43, "Program"],
Cell[3888, 135, 718, 19, 72, "Text"],
Cell[CellGroupData[{
Cell[4631, 158, 145, 4, 30, "Input",
 InitializationCell->True],
Cell[4779, 164, 156, 3, 29, "Output"]
}, Open  ]],
Cell[4950, 170, 745, 24, 72, "Text"],
Cell[5698, 196, 267, 7, 34, "Text"],
Cell[5968, 205, 77, 0, 42, "Program"],
Cell[6048, 207, 1018, 29, 92, "Text"],
Cell[7069, 238, 157, 4, 30, "Input",
 InitializationCell->True],
Cell[7229, 244, 234, 7, 34, "Text"],
Cell[CellGroupData[{
Cell[7488, 255, 128, 3, 30, "Input",
 InitializationCell->True],
Cell[7619, 260, 262, 7, 29, "Output"]
}, Open  ]],
Cell[7896, 270, 983, 33, 72, "Text"],
Cell[8882, 305, 160, 5, 48, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[9079, 315, 26, 0, 37, "Section"],
Cell[9108, 317, 64, 3, 37, "Input"],
Cell[9175, 322, 186, 5, 26, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

